// SPDX-License-Identifier: GPL-2.0
import QtQuick 2.6
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.2 as Controls
import QtQuick.Window 2.2
import org.kde.kirigami 2.4 as Kirigami
import org.subsurfacedivelog.mobile 1.0

Kirigami.Page {

	title: "Theme Information"
	background: Rectangle { color: subsurfaceTheme.backgroundColor }

	FontMetrics {
		id: fontMetrics
	}

	GridLayout {
		id: themetest
		columns: 2
		anchors.margins: Kirigami.Units.gridUnit / 2

		Kirigami.Heading {
			Layout.columnSpan: 2
			text: "Theme Information"
		}

		Kirigami.Heading {
			text: "Screen"
			Layout.columnSpan: 2
			level: 3
		}

		Controls.Label {
			text: "Geometry (pixels):"
		}
		Controls.Label {
			text: rootItem.width + "x" + rootItem.height
		}

		Controls.Label {
			text: "Geometry (gridUnits):"
		}
		Controls.Label {
			text: Math.round(rootItem.width / Kirigami.Units.gridUnit) + "x" + Math.round(rootItem.height / Kirigami.Units.gridUnit)
		}

		Controls.Label {
			text: "Units.gridUnit:"
		}
		Controls.Label {
			text: Kirigami.Units.gridUnit
		}

		Controls.Label {
			text: "Units.devicePixelRatio:"
		}
		Controls.Label {
			text: Screen.devicePixelRatio
		}

		Kirigami.Heading {
			text: "Font Metrics"
			level: 3
			Layout.columnSpan: 2
		}

		Controls.Label {
			text: "basePointSize:"
		}
		Controls.Label {
			text: subsurfaceTheme.basePointSize
		}

		Controls.Label {
			text: "FontMetrics pointSize:"
		}
		Controls.Label {
			text: fontMetrics.font.pointSize
		}

		Controls.Label {
			text: "FontMetrics pixelSize:"
		}
		Controls.Label {
			text: Number(fontMetrics.height).toFixed(2)
		}

		Controls.Label {
			text: "FontMetrics devicePixelRatio:"
		}
		Controls.Label {
			text: Number(fontMetrics.height / fontMetrics.font.pointSize).toFixed(2)
		}

		Controls.Label {
			text: "Text item pixelSize:"
		}
		Text {
			text: fontMetrics.font.pixelSize
		}

		Controls.Label {
			text: "Text item pointSize:"
		}
		Text {
			text: fontMetrics.font.pointSize
		}

		Controls.Label {
			text: "Pixel density:"
		}
		Text {
			text: Number(Screen.pixelDensity).toFixed(2)
		}

		Controls.Label {
			text: "Height of default font:"
		}
		Text {
			text: Number(fontMetrics.font.pixelSize / Screen.pixelDensity).toFixed(2) + "mm"
		}

		Controls.Label {
			text: "2cm x 2cm square:"
		}
		Rectangle {
			width: Math.round(Screen.pixelDensity * 20)
			height: Math.round(Screen.pixelDensity * 20)
			color: "black"
		}

		Controls.Label {
			Layout.columnSpan: 2
			Layout.fillHeight: true
		}
	}
}
