// SPDX-License-Identifier: GPL-2.0
#include "testprofile.h"
#include "core/device.h"
#include "core/divesite.h"
#include "core/trip.h"
#include "core/file.h"
#include "core/save-profiledata.h"
#include "core/pref.h"
#include "QTextCodec"

// This test compares the content of struct profile against a known reference version for a list
// of dives to prevent accidental regressions. Thus is you change anything in the profile this
// test will fail. If this change was intentional, run the test manually. Make sure only the
// indended fields change (for example by computing a diff between exportprofile.csv and
// ..dives/exportprofilereference.csv) and copy the former over the later and commit that change
// as well.

void TestProfile::init()
{
	// Set UTF8 text codec as in real applications
	QTextCodec::setCodecForLocale(QTextCodec::codecForMib(106));
	// first, setup the preferences

	// normally we should be able to do this - but it makes this test fail because the reference data
	// assume that the prefs are all 0 / false
	// copy_prefs(&default_prefs, &prefs);
	// instead we just set up the cloud_base_url to prevent parse_file() from crashing
	prefs.cloud_base_url = strdup(default_prefs.cloud_base_url);

	QCoreApplication::setOrganizationName("Subsurface");
	QCoreApplication::setOrganizationDomain("subsurface.hohndel.org");
	QCoreApplication::setApplicationName("Subsurface");
}
void TestProfile::testProfileExport()
{
	prefs.planner_deco_mode = BUEHLMANN;
	parse_file(SUBSURFACE_TEST_DATA "/dives/abitofeverything.ssrf", &dive_table, &trip_table, &dive_site_table, &device_table, &filter_preset_table);
	save_profiledata("exportprofile.csv", false);
	QFile org(SUBSURFACE_TEST_DATA "/dives/exportprofilereference.csv");
	QCOMPARE(org.open(QFile::ReadOnly), true);
	QFile out("exportprofile.csv");
	QCOMPARE(out.open(QFile::ReadOnly), true);
	QTextStream orgS(&org);
	QTextStream outS(&out);
	QString readin = orgS.readAll();
	QString written = outS.readAll();
	QCOMPARE(readin, written);

}
void TestProfile::testProfileExportVPMB()
{
	prefs.planner_deco_mode = VPMB;
	parse_file(SUBSURFACE_TEST_DATA "/dives/abitofeverything.ssrf", &dive_table, &trip_table, &dive_site_table, &device_table, &filter_preset_table);
	save_profiledata("exportprofileVPMB.csv", false);
	QFile org(SUBSURFACE_TEST_DATA "/dives/exportprofilereferenceVPMB.csv");
	QCOMPARE(org.open(QFile::ReadOnly), true);
	QFile out("exportprofileVPMB.csv");
	QCOMPARE(out.open(QFile::ReadOnly), true);
	QTextStream orgS(&org);
	QTextStream outS(&out);
	QString readin = orgS.readAll();
	QString written = outS.readAll();
	QCOMPARE(readin, written);

}

QTEST_GUILESS_MAIN(TestProfile)
